# import des different composants necessaires
import vtk
from vtk import *
import math
from math import *

# ------------------------------------------------
# creation de structure de donnee,i.e la grille
# ------------------------------------------------

x = [0,0,0]
rMin = 0.5
rMax = 1.0
dims = [13, 11, 11]
  
# Create the structured grid.
dataset = vtkStructuredGrid()
dataset.SetDimensions(dims);

# We also create the points and datas. The points
# form a hemi-cylinder of data.

scalarData = vtkFloatArray()
points = vtkPoints()
  
deltaZ = 2.0 / (dims[2]-1)
deltaRad = (rMax-rMin) / (dims[1]-1)
for k in range(dims[2]):
    x[2] = -1.0 + k*deltaZ
    kOffset = k * dims[0] * dims[1]
    for j in range(dims[1]):
      radius = rMin + j*deltaRad
      jOffset = j * dims[0]
      for i in range(dims[0]):
        theta = i * 15.0 * math.pi/180.0  #vtkMath.DegreesToRadians()
        x[0] = radius * cos(theta)
        x[1] = radius * sin(theta)
        offset = i + jOffset + kOffset
        points.InsertPoint(offset,x)
        valeur = offset
        scalarData.InsertTuple1(offset,valeur)
        
dataset.SetPoints(points)
dataset.GetPointData().SetScalars(scalarData)

# ------------------------------------------------
# fin de la creation de structure de donnee
# ------------------------------------------------